﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{


    public class QuotationsDB
    {
        public static Quotations GetItem(Guid quotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            Quotations myQuotations = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myQuotations = SQLHelper.RetrieveObject<Quotations>("spGetQuotations", parameters);
            myQuotations.QuotationsDetailsList = QuotationsDetailsDB.GetList(Guid.Empty, myQuotations.UniqueID, string.Empty);

            return myQuotations;
        }

        public static List<Quotations> GetList(Guid quotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<Quotations> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myList = SQLHelper.RetrieveList<Quotations>("spGetQuotations", parameters);

            foreach (Quotations currentTransaction in myList)
            {
                currentTransaction.QuotationsDetailsList = QuotationsDetailsDB.GetList(Guid.Empty, currentTransaction.UniqueID, string.Empty);
            }

            return myList;
        }

        public static DataTable GetDataTable(Guid quotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetQuotations", parameters);
        }

        public static DataSet GetDataSet(Guid quotationsID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", ((quotationsID != Guid.Empty && quotationsID != null) ? quotationsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetQuotations", parameters);
        }

        public static void Save(Quotations myQuotations)
        {
            myQuotations.Mode = ((myQuotations.UniqueID != Guid.Empty && myQuotations.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myQuotations.UniqueID = ((myQuotations.UniqueID != Guid.Empty && myQuotations.UniqueID != null) ? myQuotations.UniqueID : Guid.NewGuid());
            if (myQuotations.Mode == GlobalConfigurations.Mode.Insert)
            {
                myQuotations.IsActive = true;
                //myQuotations.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@QuotationsID", myQuotations.UniqueID));
            parameters.Add(new SqlParameter("@OrderFrom", (string.IsNullOrEmpty(myQuotations.OrderFrom) ? (object)DBNull.Value : myQuotations.OrderFrom)));
            parameters.Add(new SqlParameter("@UsersAccountID", ((myQuotations.UsersAccountID != Guid.Empty && myQuotations.UsersAccountID != null) ? myQuotations.UsersAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FirstName", (string.IsNullOrEmpty(myQuotations.FirstName) ? (object)DBNull.Value : myQuotations.FirstName)));
            parameters.Add(new SqlParameter("@LastName", (string.IsNullOrEmpty(myQuotations.LastName) ? (object)DBNull.Value : myQuotations.LastName)));
            parameters.Add(new SqlParameter("@Email", (string.IsNullOrEmpty(myQuotations.Email) ? (object)DBNull.Value : myQuotations.Email)));
            parameters.Add(new SqlParameter("@Company", (string.IsNullOrEmpty(myQuotations.Company) ? (object)DBNull.Value : myQuotations.Company)));
            parameters.Add(new SqlParameter("@BillingAddress1", (string.IsNullOrEmpty(myQuotations.BillingAddress1) ? (object)DBNull.Value : myQuotations.BillingAddress1)));
            parameters.Add(new SqlParameter("@BillingAddress2", (string.IsNullOrEmpty(myQuotations.BillingAddress2) ? (object)DBNull.Value : myQuotations.BillingAddress2)));
            parameters.Add(new SqlParameter("@BillingCity", (string.IsNullOrEmpty(myQuotations.BillingCity) ? (object)DBNull.Value : myQuotations.BillingCity)));
            parameters.Add(new SqlParameter("@BillingState", (string.IsNullOrEmpty(myQuotations.BillingState) ? (object)DBNull.Value : myQuotations.BillingState)));
            parameters.Add(new SqlParameter("@BillingCountry", (string.IsNullOrEmpty(myQuotations.BillingCountry) ? (object)DBNull.Value : myQuotations.BillingCountry)));
            parameters.Add(new SqlParameter("@BillingPostalCode", (string.IsNullOrEmpty(myQuotations.BillingPostalCode) ? (object)DBNull.Value : myQuotations.BillingPostalCode)));
            parameters.Add(new SqlParameter("@BillingMobile", (string.IsNullOrEmpty(myQuotations.BillingMobile) ? (object)DBNull.Value : myQuotations.BillingMobile)));
            parameters.Add(new SqlParameter("@BillingPhone", (string.IsNullOrEmpty(myQuotations.BillingPhone) ? (object)DBNull.Value : myQuotations.BillingPhone)));
            parameters.Add(new SqlParameter("@ShippingAddress1", (string.IsNullOrEmpty(myQuotations.ShippingAddress1) ? (object)DBNull.Value : myQuotations.ShippingAddress1)));
            parameters.Add(new SqlParameter("@ShippingAddress2", (string.IsNullOrEmpty(myQuotations.ShippingAddress2) ? (object)DBNull.Value : myQuotations.ShippingAddress2)));
            parameters.Add(new SqlParameter("@ShippingCity", (string.IsNullOrEmpty(myQuotations.ShippingCity) ? (object)DBNull.Value : myQuotations.ShippingCity)));
            parameters.Add(new SqlParameter("@ShippingState", (string.IsNullOrEmpty(myQuotations.ShippingState) ? (object)DBNull.Value : myQuotations.ShippingState)));
            parameters.Add(new SqlParameter("@ShippingCountry", (string.IsNullOrEmpty(myQuotations.ShippingCountry) ? (object)DBNull.Value : myQuotations.ShippingCountry)));
            parameters.Add(new SqlParameter("@ShippingPostalCode", (string.IsNullOrEmpty(myQuotations.ShippingPostalCode) ? (object)DBNull.Value : myQuotations.ShippingPostalCode)));
            parameters.Add(new SqlParameter("@ShippingMobile", (string.IsNullOrEmpty(myQuotations.ShippingMobile) ? (object)DBNull.Value : myQuotations.ShippingMobile)));
            parameters.Add(new SqlParameter("@ShippingPhone", (string.IsNullOrEmpty(myQuotations.ShippingPhone) ? (object)DBNull.Value : myQuotations.ShippingPhone)));
            parameters.Add(new SqlParameter("@IsShipToBillingAddress", myQuotations.IsShipToBillingAddress));
            parameters.Add(new SqlParameter("@SubTotal", (myQuotations.SubTotal == 0 ? (object)DBNull.Value : myQuotations.SubTotal)));
            parameters.Add(new SqlParameter("@Discount", (myQuotations.Discount == 0 ? (object)DBNull.Value : myQuotations.Discount)));
            parameters.Add(new SqlParameter("@Shipping", (myQuotations.Shipping == 0 ? (object)DBNull.Value : myQuotations.Shipping)));
            parameters.Add(new SqlParameter("@TotalBeforeGST", (myQuotations.TotalBeforeGST == 0 ? (object)DBNull.Value : myQuotations.TotalBeforeGST)));
            parameters.Add(new SqlParameter("@GST", (myQuotations.GST == 0 ? (object)DBNull.Value : myQuotations.GST)));
            parameters.Add(new SqlParameter("@Total", (myQuotations.Total == 0 ? (object)DBNull.Value : myQuotations.Total)));
            parameters.Add(new SqlParameter("@Comments", (string.IsNullOrEmpty(myQuotations.Comments) ? (object)DBNull.Value : myQuotations.Comments)));
            parameters.Add(new SqlParameter("@QuotationsNumber", (string.IsNullOrEmpty(myQuotations.QuotationsNumber) ? (object)DBNull.Value : myQuotations.QuotationsNumber)));
            parameters.Add(new SqlParameter("@QuotationsStatus", (string.IsNullOrEmpty(myQuotations.QuotationsStatus) ? (object)DBNull.Value : myQuotations.QuotationsStatus)));
            parameters.Add(new SqlParameter("@ExpiryDate", (myQuotations.ExpiryDate == DateTime.MinValue ? (object)DBNull.Value : myQuotations.ExpiryDate)));
            parameters.Add(new SqlParameter("@DesignerName", (string.IsNullOrEmpty(myQuotations.DesignerName) ? (object)DBNull.Value : myQuotations.DesignerName)));
            parameters.Add(new SqlParameter("@DesignerRemarks", (string.IsNullOrEmpty(myQuotations.DesignerRemarks) ? (object)DBNull.Value : myQuotations.DesignerRemarks)));
            parameters.Add(new SqlParameter("@CreatedBy", ((myQuotations.AdminUserAccountID != Guid.Empty && myQuotations.AdminUserAccountID != null) ? myQuotations.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myQuotations.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myQuotations.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myQuotations.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateQuotations", parameters);
        }

        public static void GenerateInvoice(Guid QuotationsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", QuotationsID));

            SQLHelper.ExecuteQuery("spGenerateInvoiceForQuotations", parameters);
        }

        public static void GenerateDO(Guid QuotationsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@QuotationsID", QuotationsID));

            SQLHelper.ExecuteQuery("spGenerateDOForQuotations", parameters);
        }
    }
}
